
#need to set working directory
#setwd()
source("02 data analysis.R") #the output of that script is full_summary2
all_data <- full_summary2

# FDR ---------------------------------------------------------------------
#test FDR per bioassay for the p vals of those seed lots that were not affected by the MRT
data <- all_data
data1 <- data[data$Ger_energy != "affected", ]
data2 <- data1[data1$Ger_capacity != "affected", ] 

total <- unique(all_data$BioassayType)
total1 <- total[total!= "Onion_Phoma"]
total <- total1[total1!= "Spinach_Fusarium"]

FDRs_bio1 <- c()
FDRs_bio2 <- c()

for(i in 1:length(total)){
  FDRs_bio1[i] <- sum((p.adjust(data2[data2$BioassayType==total[[i]],]$P_value_bio1, method = "BH") <0.05) * 0.10)
  FDRs_bio2[i] <- sum((p.adjust(data2[data2$BioassayType==total[[i]],]$P_value_bio2, method = "BH") <0.05) * 0.10)
}

#table of FDRs; not including "Onion_Phoma" and "Spinach_Fusarium"
FDRs <- data.frame(SeedLot = total, FDRs_bio1 = FDRs_bio1, FDRs_bio2 = FDRs_bio2)

# manually adjust for Fig.2 to account for FDR ---------------------------------------------------------------------
# Seed Lots to call non-responsive
# Selected based on having (relatively) the largest p value and 
# smallest average difference in untrt-trt
# Spinach_Pythium
# Var 1 x2 325, 337


all_data$Bio_var1[which(
  all_data$SeedLot %in% c(325, 337)&
  all_data$BioassayType %in% 
  c('Spinach_Pythium'))] <- 'Non-responsive seed lots'


# visualise non-affected and adjust for FDR -----------------------------------------
# packages also loaded in sourced script '01 data analysis.R'
library(ggplot2)
library(tidyverse)
library(ggpubr)
library(ggrepel)


#have the right name appear for bioassay pepper B
all_data$BioassayType[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')] <- 'Pepper seedlings_Phytophthora capsici'

data <- all_data
data1 <- data[data$Ger_energy != "affected", ]
data2 <- data1[data1$Ger_capacity != "affected", ] 

#calculate frequency for Bio_var1 and Bio_var2
try1 <- data2
try1$Variable <- 'Disease Variable 1'
try1$Bio_var<- try1$Bio_var1
try1$BioassayCODE<- paste(try1$BioassayType, '_', try1$Variable)

try2 <- data2
try2$Variable <- 'Disease Variable 2'
try2$Bio_var<- try2$Bio_var2
try2$BioassayCODE<- paste(try2$BioassayType, '_', try2$Variable)

try12 <- try1[,c(1, 4, 5, 14, 15, 16)]
try22 <- try2[,c(1, 4, 5, 14, 15, 16)]
dataa <- rbind(try12, try22)

#important! uninstall plyr for the code below to work
detach("package:plyr", unload = TRUE)

dataa$Row1 <- 1
x1<- dataa%>%
  group_by(BioassayCODE, Bio_var)%>%
  summarise(Frequency = sum(Row1))
df5 <- x1
head(df5)

split_data <- data.frame(str_split_fixed(df5$BioassayCODE, '_', 3))
colnames(split_data) <- c('Crop', 'BioassayType', 'Variable')
split_data$BioassayType<- paste(split_data$Crop, '-', split_data$BioassayType)

df5 <- data.frame(df5, split_data)

#adjust for var2 grass bioassays; otherwise ggballoonplot won't work
df5$Frequency <- as.numeric(df5$Frequency)

df5[c(27, 29, 31), 3] <- 'NA'
df5[c(27, 29, 31),2] <- "Non-responsive seed lots"

df5$Frequency <- as.numeric(df5$Frequency)

df5$Crop[which(df5$Crop == 'Pepper plants')] <- 'Pepper'
df5$Crop[which(df5$Crop == 'Pepper seedlings')] <- 'Pepper'

c <- ggballoonplot(df5, x = "Bio_var", y = "BioassayType" , fill = "Bio_var", 
                   ggtheme = theme_bw()) +
  geom_label_repel(aes(label = Frequency), size = 3.5,
                   box.padding   = 0.01,
                   point.padding = 0.01,
                   segment.color = "black",
                   nudge_x = 0.2, nudge_y = 0.2, 
                   min.segment.length = Inf) 

c + facet_grid(~ Variable, scale = 'free')  + 
  scale_y_discrete(limits = c("Perennial ryegrass - Puccinia sp. ",
                              "Perennial ryegrass - Laetisaria fuciformis ",
                              "Red fescue - Laetisaria fuciformis ",
                              "Pepper plants - Phytophthora capsici ",
                              "Pepper seedlings - Phytophthora capsici ",
                              "Coriander - Pythium ",         
                              "Spinach - Fusarium ",
                              "Spinach - Pythium ",
                              "Onion - Fusarium ",                      
                              "Onion - Phoma ",                     
                              "Beetroot - Pythium "),
                   labels=c("Perennial ryegrass -"~italic(Puccinia)~"sp. ", 
                            "Perennial ryegrass -"~italic(Laetisaria)~~italic(fuciformis)~" ",
                            "Red fescue -"~italic(Laetisaria)~~italic(fuciformis)~" ",
                            "Pepper (plants) -"~italic(Phytophthora)~~italic(capsici)~" ",
                            "Pepper (seedlings) -"~italic(Phytophthora)~~italic(capsici)~" ",
                            "Coriander -"~italic(Pythium)~"sp.",
                            "Spinach -"~italic(Fusarium)~~italic(oxysporum)~" f. sp." ~italic(spinaciae)~" ",
                            "Spinach -"~italic(Pythium)~~italic(ultimum)~" ",
                            "Onion -"~italic(Fusarium)~~italic(oxysporum)~" f. sp." ~italic(cepae)~" ",
                            "Onion -"~italic(Setophoma)~~italic(terrestris)~" ",
                            "Beetroot -"~italic(Pythium)~~italic(ultimum)~" ")) + 
  scale_x_discrete(limits = c("Promising seed lots",
                              "Non-responsive seed lots", 
                              "Negatively responsive seed lots"),
                   labels = c('Positively responsive seed lots',
                            'Non-responsive seed lots',
                            'Negatively responsive seed lots')) +
  guides(fill='none') +
  theme(axis.text.x=element_text(size=rel(1.3), angle = 35, colour="black"), 
        axis.text.y=element_text(size=rel(1.3), colour="black"), 
        strip.text.x = element_text(size=rel(1.5), colour="black"),
        plot.margin=unit(c(1,1,1,1),"cm"),
        legend.position='none') +
  scale_fill_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

#saved as (landscape) pdf 8.00 x 6.50


